import subprocess
import itertools

# Baseline safe parameters
super_list = [128, 256, 512, 1024]
instances_list = [2048, 4096, 8192]
slice_list = [8, 16, 32]

best_combo = None
best_fps = 0.0

for NUM_SUPER, NUM_INSTANCES, MAX_SLICE in itertools.product(super_list, instances_list, slice_list):
    print(f"Testing NUM_SUPER={NUM_SUPER}, NUM_INSTANCES={NUM_INSTANCES}, MAX_SLICE={MAX_SLICE}")
    
    # Update prismatic5m.py parameters
    with open("prismatic5m.py","r") as f:
        src = f.read()
    src = src.replace(f"NUM_SUPER = {NUM_SUPER}", f"NUM_SUPER = {NUM_SUPER}")
    src = src.replace(f"NUM_INSTANCES = {NUM_INSTANCES}", f"NUM_INSTANCES = {NUM_INSTANCES}")
    src = src.replace(f"MAX_SLICE = {MAX_SLICE}", f"MAX_SLICE = {MAX_SLICE}")
    with open("prismatic5m_temp.py","w") as f:
        f.write(src)
    
    # Launch subprocess and monitor GPU (simplified)
    try:
        proc = subprocess.Popen(["python","prismatic5m_temp.py"])
        # Wait a few seconds to measure FPS / stability
        proc.wait(timeout=5)
        # In practice, hook into GPU counters or OpenGL timer queries
        fps = 60.0  # placeholder for actual measurement
        if fps > best_fps:
            best_fps = fps
            best_combo = (NUM_SUPER, NUM_INSTANCES, MAX_SLICE)
    except Exception as e:
        print(f"Failed combination: {e}")
    finally:
        proc.terminate()

print(f"Optimal RX 480 TFLOPs combination: NUM_SUPER={best_combo[0]}, NUM_INSTANCES={best_combo[1]}, MAX_SLICE={best_combo[2]}, FPS={best_fps}")
